/*
 * Author: Kevin J. Moye - 8/04/2004
 * Code for identifying commercial start/stop points (time & file positions)
 * from ReplayTV 4K & 5K series .ndx and .evt files.
 * The intent is to integrate this code with VideoLAN VLC to enable
 * Automatic Commercial Advance while playing or streaming an RTV mpeg.
 *
 * This code is HEAVILY based on replaypc and rtvtools code for
 * parsing .ndx and .evt files.
 */
#ifndef _rtvparse_h_
#define _rtvparse_h_

// rtv.h (from rtvtools)
#include <stdio.h>
#include <stdlib.h>

#ifndef _LARGEFILE64_SOURCE  // added
#define _LARGEFILE64_SOURCE
#endif
typedef unsigned char      u8;
typedef unsigned short     u16;
typedef unsigned long      u32;
//typedef unsigned long long u64;
typedef          long long s64;

#ifndef __BYTE_ORDER
#define __BYTE_ORDER		4321
#endif
typedef char			INT8;
typedef short			INT16;
#ifndef WIN32
typedef long			INT32;
typedef long long		INT64;
#endif
typedef unsigned char		UINT8;
typedef unsigned short		UINT16;
#ifndef WIN32
typedef unsigned long		UINT32;
typedef unsigned long long	UINT64;
#ifndef BOOL
typedef char			BOOL;
#endif
#endif

#ifndef EXPECT_CAN_EXIT
#define EXPECT_CAN_EXIT 0
#endif

#define RTV_DELAY_SECONDS 40 // 795KB/SEC (+/- 64KB/SEC)

extern u8   rtv_to_u8(unsigned char ** pp);
extern u16  rtv_to_u16(unsigned char ** pp);
extern u32  rtv_to_u32(unsigned char ** pp);
extern u64  rtv_to_u64(unsigned char ** pp);
extern void rtv_from_u8(unsigned char ** p, u8 v);
extern void rtv_from_u16(unsigned char ** pp, u16 v);
extern void rtv_from_u32(unsigned char ** pp, u32 v);
extern void rtv_from_u64(unsigned char ** pp, u64 v);

#define expect(x) do {                                          \
    if (!(x)) {                                                 \
        fprintf(stderr, "Unexpected %s %s:%d\n", #x, __FILE__, __LINE__);    \
        if (EXPECT_CAN_EXIT) (exit(-1));                        \
    }                                                           \
} while(0)

// ndx.h (from rtvtools)
struct ndx4k_record 
{
/*  0 */ u8  flag_1;
/*  1 */ u8  commercial_flag;
/*  2 */ u16 video_offset; /* relative to stream_position */
/*  4 */ u8  unk_fe;
/*  5 */ u8  macrovision;
/*  6 */ u16 macrovision_count;
/*  8 */ u32 audio_offset; /* relative to stream_position + video_offset */
/* 12 */ u32 unused1;      /* always 0 */
/* 16 */ u64 timestamp;    /* seconds * 10e9, from an unknown base */
/* 24 */ u64 stream_position;
}; /* 32 */

struct ndx5k_record 
{
/*  0 */ u64 timestamp;      /* Timestamp in nanoseconds */
/*  8 */ u64 filepos_iframe; /* File position to an I-frame */
/* 16 */ u32 iframe_size;    /* Size of the I-frame (including PES Headers) */
/* 20 */ u32 empty;          /* Always Zero, possibly for alignment */
}; /* 24 */

typedef enum { EVT_AUD=1, EVT_VID=2 } EVT_TYPE;

typedef struct
{
	char	sig[4];
	char	ver[4];
} EVT_HEADER;

typedef struct
{
	INT64	timestamp;
	UINT32	reserved;
	UINT32	type;
	UINT32	value1;
	union
	{
		UINT32	value2;
		char	color[4];
	};
} EVT_EVENT;

typedef struct _fade
{
	struct _fade	*next;
	INT64			start;
	INT64			stop;
	UINT32			video;
	UINT32			audio;
	UINT32			type;
} FADE;

#if __BYTE_ORDER == __BIG_ENDIAN

#define SWAP16(v) (v)
#define SWAP32(v) (v)
#define SWAP64(v) (v)

#else

__inline UINT16 SWAP16(UINT16 val)
{
	return (val>>8)|(val<<8);
}
__inline UINT32 SWAP32(UINT32 val)
{
	char temp[4], *pc=(char*)&val;
	temp[0] = pc[3];
	temp[1] = pc[2];
	temp[2] = pc[1];
	temp[3] = pc[0];
	return *((UINT32*)temp);
}
__inline INT64 SWAP64(INT64 val)
{
	char temp[8], *pc=(char*)&val;
	temp[0] = pc[7];
	temp[1] = pc[6];
	temp[2] = pc[5];
	temp[3] = pc[4];
	temp[4] = pc[3];
	temp[5] = pc[2];
	temp[6] = pc[1];
	temp[7] = pc[0];
	return *((INT64*)temp);
}

#endif

UINT64 gProgTime	= 180000000000LLU;	// 3 minutes
UINT64 gMinTime		= 0000000000LLU;	// 0 seconds
UINT32 audmax, audmin = 0xFFFFFFFF;
UINT32 factor;

char* format_ts(INT64 ts, char *time);
char* vid_level(UINT32 level);
char* aud_level(UINT32 level);

struct evt5kStruct {
   u64 start;
   u64 stop;
};

struct ndx5kStruct {
   u64 time;
   u64 pos;
};

//int rtvIsInCommercial(u64 time, struct rtvCommercialMarks **s, int count);

#endif
